<?php

/**
 * The file that defines the core plugin class
 *
 * A class definition that includes attributes and functions used across both the
 * public-facing side of the site and the admin area.
 *
 * @link       sarka.com
 * @since      1.0.0
 *
 * @package    Sarka
 * @subpackage Sarka/includes
 */

/**
 * Setup API endpoints.
 *
 * @since    1.0.0
 */
function sarka_api_setup($request) {

	// Get data
	$data = $request->get_body();
	$data = json_decode($data, true); // Convert json array to PHP array

	// Extract individual array data
	$code = (string) (isset($data['code']) ? htmlentities( $data['code'] ) : null);

	// Add tracking code to database
	update_option( 'sarka_survey_code', $code );

	return true;

}

/**
 * Setup template pages.
 *
 * @since    1.0.0
 */
function sarka_template_projects() {

	// Assign default variable values
	$textarea = (string) null;

	// Get current survey code, if it exists
	if( get_option( 'sarka_survey_code' ) ) {
		$textarea = get_option( 'sarka_survey_code' );
	}

?>
	<div class="sarka-body uk-scope">

		<div class="container projects-header">
			<div class="container-core block-flex flex-gap-35">

				<div class="block-header">
					<h4 class="block-title"><?php _e( 'Sarka | Blog Monitor', 'sarka' ); ?></h4>
				</div>

				<div class="block-text">
					<p><?php _e( 'Internal Tool - Use this to keep posts updated regularly.', 'sarka' ); ?></p>
				</div>

			</div>
		</div>
		<!-- .projects-header -->

		<div class="container projects-tips">
			<div class="container-core block-flex block-flex-start w800-block-flex-column-reverse flex-gap-30">

				<div class="container-column container-col1 flex-col-rel-1">

 					<div class="block-card block-style2 x426BC6">

						<div class="block-header">
							<h3 class="block-title"><span class="dashicons dashicons-megaphone"></span>Tips - Update Ideas</h3>
						</div>
						<!-- .block-header -->

						<div class="block-body">

							<div class="block-list">

								<ul class="uk-list uk-list-circle">
									<li>Add 2 inner page links (max 10)</li>
									<li>At 10, replace 2 inner page links</li>
									<li>Add / update FAQ question</li>
								</ul>

							</div>
							<!-- .block-list -->

						</div>
						<!-- .block-body -->

					</div>

				</div>

				<div class="container-column container-col2 flex-col-rel-3 hidden">

					<div class="block-card block-card-link block-style2 xC0392B">

						<a href="" target="_blank">

							<div class="block-header">
								<h3 class="block-title"><span class="dashicons dashicons-megaphone"></span>Tip 2</h3>
							</div>

							<div class="block-body">
								<div class="block-text">
									<p>Keep your visitors happy and<br />improve user experience</p>
									<p>Read now -&gt;</p>
								</div>
							</div>

						</a>

					</div>

				</div>

				<div class="container-column container-col3 flex-col-rel-3 hidden">

					<div class="block-card block-card-link block-style2 x642b73">

						<a href="" target="_blank">

							<div class="block-header">
								<h3 class="block-title"><span class="dashicons dashicons-megaphone"></span>Tip 3</h3>
							</div>

							<div class="block-body">
								<div class="block-text">
									<p>Boost feedback response rates<br />with Sarka</p>
									<p>Read now -&gt;</p>
								</div>
							</div>

						</a>

					</div>

				</div>

			</div>
		</div>
		<!-- .projects-tips -->

		<div class="container projects-connect">
			<div class="container-core">

				<div class="container-row container-row1">

				<?php
					global $post;

					// Assign default variable values
					$count_0  = (int) null;
					$count_3  = (int) null;
					$count_6  = (int) null;
					$count_9  = (int) null;
					$count_12 = (int) null;

					// Get post data
					$args = array(
						'posts_per_page' => -1,
						'orderby'        => 'modified',
						'order'          => 'DESC'
					);
					$posts = get_posts( $args );

					// Loop through each post
					foreach ( $posts as $post ) :
						setup_postdata( $post ); ?>

						<?php
							// Get post slug
							$slug = get_the_permalink();
							$slug = str_replace( home_url(), '',  $slug);
							$slug = str_replace( '/',        '',  $slug);
							$slug = str_replace( '-',        ' ', $slug);

							// Get post dates
							$post_date     = date( 'd M, Y', strtotime( $post->post_date ) );
							$post_modified = date( 'd M, Y', strtotime( $post->post_modified ) );

							// Put post age in bin 0, 3, 6, 9 or 12 months
							$datetime1       = date_create(date( "Y-m-d H:i:s", strtotime( $post->post_modified ) ));
							$datetime2       = date_create(date( "Y-m-d H:i:s" ));
							$interval        = date_diff($datetime1, $datetime2);
							$interval_years  = $interval->format('%y');
							$interval_months = $interval->format('%m');

							// Add number of years to monght
							$interval_months = $interval_months + (12 * $interval_years);

							// Reassign interval to pre-defined bucket
							if( $interval_months >= 12 ) {
								$count_12++;
							} else if( $interval_months >= 9 ) {
								$count_9++;
							} else if( $interval_months >= 6 ) {
								$count_6++;
							} else if( $interval_months >= 3 ) {
								$count_3++;
							} else {
								$count_0++;
							}

					endforeach; wp_reset_postdata(); ?>

					<div class="block-header">

						<div class="block-text">
							<p>Total: <span id="items-count"><?php echo sizeof($posts); ?></span> / <span id="items-total"><?php echo sizeof($posts); ?></span></p>
							<p class="item-interval-count">
								<span data-value="0"><?php echo $count_0; ?></span>
								<span data-value="3"><?php echo $count_3; ?></span>
								<span data-value="6"><?php echo $count_6; ?></span>
								<span data-value="9"><?php echo $count_9; ?></span>
								<span data-value="12"><?php echo $count_12; ?></span>
							</p>
						</div>
						<!-- .block-text -->

						<div class="uk-margin block-select">
							<div class="block-header" uk-form-custom="target: true">
								<select aria-label="Custom controls" id="block-select-change">
									<option value="0">All</option>
									<option value="3">> 3 Months</option>
									<option value="6">> 6 Months</option>
									<option value="9">> 9 Months</option>
									<option value="12">> 12 Months</option>
								</select>
								<span></span>
							</div>
						</div>
						<!-- .block-select -->

					</div>
					<!-- .block-header -->

					<div class="block-body">

						<table id="block-table-posts" class="uk-table uk-table-divider block-table" data-value="0">

							<thead>

								<tr>
									<th class="item-link">Title</th>
									<th class="item-slug">Slug</th>
									<th class="item-published">Published</th>
									<th class="item-modified">Modified</th>
								</tr>

							</thead>

							<tbody>

							<?php
								global $post;

								// Get post data
								$args = array(
									'posts_per_page' => -1,
									'orderby'        => 'modified',
									'order'          => 'DESC'
								);
								$posts = get_posts( $args );

								// Loop through each post
								foreach ( $posts as $post ) :
									setup_postdata( $post ); ?>

									<?php
										// Get post slug
										$slug = get_the_permalink();
										$slug = str_replace( home_url(), '',  $slug);
										$slug = str_replace( '/',        '',  $slug);
										$slug = str_replace( '-',        ' ', $slug);

										// Get post dates
										$post_date     = date( 'd M, Y', strtotime( $post->post_date ) );
										$post_modified = date( 'd M, Y', strtotime( $post->post_modified ) );


										// Put post age in bin 0, 3, 6, 9 or 12 months
										$datetime1       = date_create(date( "Y-m-d H:i:s", strtotime( $post->post_modified ) ));
										$datetime2       = date_create(date( "Y-m-d H:i:s" ));
										$interval        = date_diff($datetime1, $datetime2);
										$interval_years  = $interval->format('%y');
										$interval_months = $interval->format('%m');

										// Add number of years to monght
										$interval_months = $interval_months + (12 * $interval_years);

										// Reassign interval to pre-defined bucket
										if( $interval_months >= 12 ) {
											$interval_months = 12;
										} else if( $interval_months >= 9 ) {
											$interval_months = 9;
										} else if( $interval_months >= 6 ) {
											$interval_months = 6;
										} else if( $interval_months >= 3 ) {
											$interval_months = 3;
										} else {
											$interval_months = 0;
										}
									?>

									<tr class="item-row" data-value="<?php echo $interval_months; ?>">
										<td class="item-link"><a href="<?php echo admin_url( 'post.php?post=' . $post->ID ); ?>&action=edit" target="_blank"><?php the_title(); ?></a></td>
										<td class="item-slug"><?php echo $slug; ?></td>
										<td class="item-published"><?php echo $post_date; ?></td>
										<td class="item-modified">
											<?php // if( $interval_months > 0 ) : ?>
												<span class="item-modified-interval"><?php echo $interval_months; ?></span>
											<?php // endif; ?>
											<span class="item-modified-date"><?php echo $post_modified; ?></span>
										</td>
									</tr>

								<?php endforeach; wp_reset_postdata(); ?>

							</tbody>

						</table>
						<!-- .block-table -->

					</div>
					<!-- .block-body -->

				</div>
				<!-- .container-row1 -->

			</div>
		</div>
		<!-- .projects-connect -->

	</div>

<?php
}
