<?php
/**
 * The template for displaying WooCommerce Single pages.
 *
 * @package ThinkUpThemes
 */

get_header(); ?>

<?php

	// Get product info
	global $product;

	// Assign default variable values
	$products = (array) null;

	// Get product variations
	$product_variations = $product->get_children();

	// Extract product info
	$product_id    = $product->get_id();
	$product_title = $product->get_title();

	// Get demo url
	$product_theme_url_demo  = get_post_meta($product_id, 'theme_url_demo', true);
	$product_theme_slug_base = get_post_meta($product_id, 'theme_slug_base', true);

	// Add parent details to products array
	$products['parent']['id']              = $product_id;
	$products['parent']['title']           = $product_title;
	$products['parent']['url_demo']        = $product_theme_url_demo;
	$products['parent']['theme_slug_base'] = $product_theme_slug_base;

	// Update products array with variation details
	foreach( $product_variations as $key => $value ) {

		// Get product variation
		$get_product = wc_get_product($value);

		// Extract variation info
		$variation_id            = (!empty($get_product->get_id())            ? $get_product->get_id()            : null);
		$variation_name          = (!empty($get_product->get_name())          ? $get_product->get_name()          : null);
		$variation_desc          = (!empty($get_product->get_description())   ? $get_product->get_description()   : null);
		$variation_price         = (!empty($get_product->get_price())         ? $get_product->get_price()         : null);
		$variation_regular_price = (!empty($get_product->get_regular_price()) ? $get_product->get_regular_price() : null);
		$variation_sale_price    = (!empty($get_product->get_sale_price())    ? $get_product->get_sale_price()    : null);

		// Format name
		$variation_name = str_replace('-', '', $variation_name);
		$variation_name = str_replace($product_title, '', $variation_name);
		$variation_name = trim( $variation_name );

		// Construct 'add to cart' url
		$variation_url_cart = untrailingslashit( get_site_url() ) . '/checkout/?add-to-cart=' . $product_id . '&variation_id=' . $variation_id;

		// Add variation details to products array
		$products['child'][$variation_id]['id']            = $variation_id;
		$products['child'][$variation_id]['name']          = $variation_name;
		$products['child'][$variation_id]['desc']          = $variation_desc;
		$products['child'][$variation_id]['price']         = $variation_price;
		$products['child'][$variation_id]['regular_price'] = $variation_regular_price;
		$products['child'][$variation_id]['sale_price']    = $variation_sale_price;
		$products['child'][$variation_id]['url_cart']      = $variation_url_cart;

		// Assign first variation as default product
		if( ! isset($products['default'] ) ) {
			$products['default'] = $products['child'][$variation_id];
		}
	}
?>

	<?php get_template_part('templates/page/theme/part/_theme_section1', '', $products); ?>
	<?php get_template_part('templates/page/theme/part/_theme_section2', '', $products); ?>
	<?php get_template_part('templates/page/theme/part/_theme_section3', '', $products); ?>
	<?php get_template_part('templates/page/theme/part/_theme_section4', '', $products); ?>
	<?php get_template_part('templates/page/theme/part/_theme_section5', '', $products); ?>

<?php get_footer() ?>