<?php
/**
 * API Downloads
 *
 * Shows API downloads on the account page.
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/api-downloads.php.
 *
 * HOWEVER, on occasion WooCommerce API Manager will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @author  Todd Lahman LLC
 * @package WooCommerce API Manager/Templates/API Downloads
 * @version 2.0
 */

defined( 'ABSPATH' ) || exit;

wc_print_notices();

if ( empty( $user_id ) ) {
	$user_id = get_current_user_id();
}

if ( ! empty( $user_id ) ) {
	// Set start time for execution.
	//$time_start = microtime( true );

	/**
	 * Every customer must have a Master API Key, and it is missing, so create it now.
	 */
	if ( empty( WC_AM_USER()->get_master_api_key( $user_id ) ) ) {
		WC_AM_USER()->set_registration_master_key_and_status( $user_id );
	}

	$master_api_key_status = WC_AM_USER()->has_api_access( $user_id );

	if ( $master_api_key_status ) {
		$resources = WC_AM_API_RESOURCE_DATA_STORE()->get_api_resources_for_user_id_sort_by_product_title( $user_id );

		if ( $resources ) {

			// Assign default variable values
			$count          = (int)   null;
			$all_products   = (array) null;
			$user_products  = (array) null;
			$user_downloads = (array) null;

			// Get current time
			$time_s_now = time();

			// Get all WC products
			$args = array(
				'post_type'      => 'product',
				'product_cat'    => 'theme',
				'posts_per_page' => -1,
			);

			// Get all WC products
			$products = new WP_Query( $args );

			// Loop through each product
			while ( $products->have_posts() ) {

				// Get product
				$products->the_post();

				// Update products array with downloads data
				$all_products[$count]['id']    = get_the_ID();
				$all_products[$count]['title'] = get_the_title();

				// Get theme version
				$all_products[$count]['theme_version'] = get_post_meta(get_the_ID(), '_api_new_version', true);

				// Add theme demo url
				$all_products[$count]['theme_url_demo'] = get_post_meta(get_the_ID(), 'theme_url_demo', true);

				// Get remote url
				$download              = WC_AM_PRODUCT_DATA_STORE()->get_first_download_url( get_the_ID() );
				$find_amazon_s3_in_url = ! empty( $download ) && WC_AM_URL()->find_amazon_s3_in_url( $download ) === true ? true : false;
				$secure_s3_url         = ! empty( $find_amazon_s3_in_url ) ? WC_AM_URL()->format_secure_s3_v4_url( $download ) : '';

				// Add theme demo url
				$all_products[$count]['theme_url_download'] = $secure_s3_url;

				$count++;
			}

			// Loop through each order and check if license is active
			foreach( $resources as $key => $value ) {

				// Convert object to array
				$value = (array) $value;

				// Extract order details
				$order_id       = (int) (isset($value['order_id'])       ? $value['order_id']       : null);;
				$access_granted = (int) (isset($value['access_granted']) ? $value['access_granted'] : null);
				$parent_id      = (int) (isset($value['parent_id'])      ? $value['parent_id']      : null);
				$product_id     = (int) (isset($value['product_id'])     ? $value['product_id']     : null);
				$sub_id         = (int) (isset($value['sub_id'])         ? $value['sub_id']         : null);

				// Rebase product ID if parent ID is set
				$product_id = (int) (!empty($parent_id) ? $parent_id : $product_id);

				// Procees if subscription product
				if( ! empty( $sub_id ) ) {

					// Get subscription information
					$subscription = new WC_Subscription($sub_id);

					// Check if subscription is active
					$subscription_active = WC_AM_Subscription()->is_user_subscription_active( wcs_get_subscription_status_name( $subscription->get_status() ) );

					// Skip to next iteraction if subscription is not active
					if( empty( $subscription_active ) ) {
						continue;
					}

				} else {

					// Get expiry date (1 year after access granted)
					$access_expires = (int) strtotime('+1 year', $access_granted);

					// Skip to next iteraction if license has expired
					if( $time_s_now > $access_expires ) {
						continue;
					}
				}

				// Update products array with product ID
				$user_products[] = $product_id;
			}

			// Remove duplicate product ID's
			$user_products = array_unique($user_products);

			// Check if user has available downloads
			if( ! empty( $user_products ) ) {

				// Check if subscription is present (exit early)
				if( in_array( '9792', $user_products ) || in_array( '239925', $user_products ) ) {

					// Add all downloads
					$user_downloads = $all_products;

				} else {

					foreach( $user_products as $key1 => $value1 ) {

						foreach( $all_products as $key2 => $value2 ) {

							if( $value1 == $value2['id'] ) {

								// Add all downloads
								$user_downloads[] = $value2;

								// Exit on first match
								break;
							}
						}
					}
				}
			}

			if( is_array( $user_downloads ) && ! empty( $user_downloads ) ) {

				// Reset counter
				$count = (int) null;

				// Sort downloads in alphabetical order
				usort($user_downloads, function ($a, $b) {
					return $a['title'] <=> $b['title'];
				});

				?>
				<table>
					<thead>
						<tr>
							<th>Theme</th>
							<th>Version</th>
							<th>Download</th>
							<th>Demo</th>
						</tr>
					</thead>
					<tbody>

					<?php foreach( $user_downloads as $key => $value ) : // Output download links ?>

						<tr>
							<td><?php echo $value['title']; ?></td>
							<td><?php echo $value['theme_version']; ?></td>
							<td><a href="<?php echo $value['theme_url_download']; ?>">Download</a></td>
							<td><a href="<?php echo $value['theme_url_demo']; ?>" target="_blank">View Demo</a></td>
						</tr>

					<?php endforeach; ?>

					</tbody>
				</table>
				<?php

			} else {

				?>
				<div class="woocommerce-Message woocommerce-Message--info woocommerce-info">
					<a class="woocommerce-Button button"
					href="<?php echo esc_url( apply_filters( 'wc_api_manager_return_to_shop_redirect', wc_get_page_permalink( 'shop' ) ) ); ?>">
						<?php esc_html_e( 'Go shop', 'woocommerce-api-manager' ) ?>
					</a>
					<?php esc_html_e( 'No API downloads available yet.', 'woocommerce-api-manager' ); ?>
				</div>
				<?php
			}
		}
	}
}