<?php
/**
 * Thankyou page
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/checkout/thankyou.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 3.7.0
 */

defined( 'ABSPATH' ) || exit;
?>

<div class="woocommerce-order">

	<?php
	if ( $order ) :

		// Assign default variable values
		$order_id              = (int)    null;
		$product_id            = (int)    null;
		$variation_id          = (int)    null;
		$product_title         = (string) null;
		$product_order_api_key = (string) null;
		$product_download      = (string) null;
		$product_download_url  = (string) null;

		// Get order ID
		$order_id = $order->get_id();

		// Get products in order
		$products = $order->get_items();

		// Get product details
		foreach($products as $product) {

			// Extract product info
			$product_id   = $product->get_product_id();
			$variation_id = $product->get_variation_id();

			// Set product ID to use for API key
			$api_product_id = (int) (!empty( $variation_id ) ? $variation_id : $product_id);

			// Get product title
			$product_title = get_the_title( $product_id );

			// Get order API key
			$product_order_api_key = WC_AM_API_RESOURCE_DATA_STORE()->get_api_resource_product_order_api_key( $order_id, $api_product_id );

			// Edit early if product is "Themes Club" (9792 - old) or  "Theme Club" (239925 - new)
			if( $product_id == 9792 || $product_id == 239925 ) {
				break;
			}

			// Get download url
			$product_download     = WC_AM_PRODUCT_DATA_STORE()->get_first_download_url( $product_id );
			$product_download_url = WC_AM_URL()->format_secure_s3_v4_url( $product_download );

			// Exit loop on first match
			break;
		}

		do_action( 'woocommerce_before_thankyou', $order->get_id() );
		?>

		<?php if ( $order->has_status( 'failed' ) ) : ?>

			<p class="woocommerce-notice woocommerce-notice--error woocommerce-thankyou-order-failed"><?php esc_html_e( 'Unfortunately your order cannot be processed as the originating bank/merchant has declined your transaction. Please attempt your purchase again.', 'woocommerce' ); ?></p>

			<p class="woocommerce-notice woocommerce-notice--error woocommerce-thankyou-order-failed-actions">
				<a href="<?php echo esc_url( $order->get_checkout_payment_url() ); ?>" class="button pay"><?php esc_html_e( 'Pay', 'woocommerce' ); ?></a>
				<?php if ( is_user_logged_in() ) : ?>
					<a href="<?php echo esc_url( wc_get_page_permalink( 'myaccount' ) ); ?>" class="button pay"><?php esc_html_e( 'My account', 'woocommerce' ); ?></a>
				<?php endif; ?>
			</p>

		<?php else : ?>


			<div class="block-card block-style1 block-after margin-bottom-50">
				<div class="block-card-core">

					<div class="block-header">
						<h3 class="block-title">Your order is ready!</h3>
					</div>
					<!-- .block-header -->

					<div class="block-body">

						<div class="block-text">
							<p>Thank you for purchasing <?php echo $product_title; ?> from ThinkUpThemes.</p>
							<p>Need support with installing your theme? You can find installation instructions in our Support Center here:<br><a href="<?php echo untrailingslashit( get_site_url() ) ?>/support/" target="_blank"><?php echo untrailingslashit( get_site_url() ) ?>/support/</a></p>
						</div>

					</div>
					<!-- .block-body -->

					<div class="block-footer">

						<div class="block-buttons">
							<button class="button button-link button-m button-v1 button-cart border-radius-5 margin-right-0" data-upify-event="button-cta-trial">
								<?php if( ! empty( $product_download ) ) : ?>
									<a href="<?php echo $product_download_url; ?>">Download Theme</a>
								<?php else: ?>
									<a href="<?php echo untrailingslashit( get_site_url() ) ?>/my-account/api-downloads/" target="_blank">Download Themes</a>
								<?php endif; ?>
							</button>
						</div>

					</div>
					<!-- .block-footer -->

				</div>
				<!-- .block-card-core -->

			</div>
			<!-- .block-card -->

			<div class="block-card block-after block-style1 margin-bottom-50">
				<div class="block-card-core">

					<div class="block-header">
						<h3 class="block-title">Install</h3>
					</div>
					<!-- .block-header -->

					<div class="block-body">

						<div class="block-text">
							<p>Install your theme in just a few clicks. See our documentation for step-by-step instructions.</p>
						</div>

					</div>
					<!-- .block-body -->

					<div class="block-footer">

						<div class="block-buttons">
							<button class="button button-link button-m button-v1 button-cart border-radius-5 margin-right-0" data-upify-event="button-cta-trial">
								<a href="<?php echo untrailingslashit( get_site_url() ) ?>/docs/">Knowledge Base</a>
							</button>
						</div>

					</div>
					<!-- .block-footer -->

				</div>
				<!-- .block-card-core -->

			</div>
			<!-- .block-card -->

			<div class="block-card block-after block-style1 block-api margin-bottom-50">
				<div class="block-card-core">

					<div class="block-header">
						<h3 class="block-title">Activate</h3>
					</div>
					<!-- .block-header -->

					<div class="block-body">

						<div class="block-text">
							<p>After installing your theme, activate it with your unique API key to enable auto-updates and support.</p><p class="api-id margin-bottom-0"><span><?php echo $product_order_api_key; ?></span></p>
						</div>

					</div>
					<!-- .block-body -->

				</div>
				<!-- .block-card-core -->

			</div>
			<!-- .block-card -->

			<div class="block-card block-style1">
				<div class="block-card-core">

					<div class="block-header">
						<h3 class="block-title">Great job! You're all set!</h3>
					</div>
					<!-- .block-header -->

					<div class="block-body">

						<div class="block-text">
							<p>Remember, if you ever need support, we're here to help! You can get in touch with our devs from the <a>support center</a>.</p>
						</div>

					</div>
					<!-- .block-body -->

					<div class="block-footer">

						<div class="block-buttons">
							<button class="button button-link button-m button-v1 button-cart border-radius-5 margin-right-0" data-upify-event="button-cta-trial">
								<a href="<?php echo untrailingslashit( get_site_url() ) ?>/my-account/">Go to My Account</a>
							</button>
						</div>

					</div>
					<!-- .block-footer -->

				</div>
				<!-- .block-card-core -->

			</div>
			<!-- .block-card -->

		<?php endif; ?>

		<?php // do_action( 'woocommerce_thankyou_' . $order->get_payment_method(), $order->get_id() ); ?>
		<?php // do_action( 'woocommerce_thankyou', $order->get_id() ); ?>

	<?php else : ?>

		<p class="woocommerce-notice woocommerce-notice--success woocommerce-thankyou-order-received"><?php echo apply_filters( 'woocommerce_thankyou_order_received_text', esc_html__( 'Thank you. Your order has been received.', 'woocommerce' ), null ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?></p>

	<?php endif; ?>

</div>
