<?php
/**
 * Template Name: Blog (Archive)
 *
 * @package ThinkUpThemes
 */

get_header(); ?>

			<?php
				$thinkup_blog_pageid = $post->ID; // Store page id to collect meta data in project loop
			?>

			<?php
			$categories = NULL;
			$posttags   = get_the_tags();
			if( is_array( get_the_tags() ) ) { $tag_count = sizeof( get_the_tags() ); }

			// Find category ID's for tag name and comma separate
			if ($posttags) {
				foreach($posttags as $tag) {
					if ($count !== ( $tag_count - 1 ) ) {
						$categories .= get_cat_ID( $tag->name ) . ',';
					} else {
						$categories .= get_cat_ID( $tag->name );
					}
					$count++;
				}
			}
			?>

			<?php
			// Ensure pagination works correctly on both front page and inner pages
			if ( is_front_page() ) {
				$paged = ( get_query_var('page') ) ? get_query_var('page') : 1;
			} else {
				$paged = ( get_query_var('paged') ) ? get_query_var('paged') : 1;
			}

			$categoryIds = get_category_by_slug( get_post_field( 'post_name', get_post() ) );
			$categoryId  = $categoryIds->term_id;

			// Run query to collect blog posts
			$loop_args = array(
				'post_type'      => 'post',
				'post_status'    => 'publish',
				'cat'            => $categoryId,
				'posts_per_page' => thinkup_input_blogpostcount(),
				'paged'          => $paged,
				'page'           => $paged,
				'orderby'        => 'modified',
			);
			$loop = new WP_Query( $loop_args );
			?>

			<?php if ( $loop->have_posts() ) : ?>

				<section class="container blog-posts">

					<div class="container-core">

						<div class="block-header block-flex">

							<div class="block-back">
								<a href="<?php echo trailingslashit( get_home_url() ) ?>"><i class="far fa-arrow-left"></i> Back to blog</a>
							</div>

							<div class="block-category">
								<h1 class="block-title margin-0"><?php echo get_cat_name( $categoryId ); ?></h3>
							</div>

						</div>

						<div class="block-content">

							<div class="blog-grid block-grid grid-col-3 grid-gap-50 w800-grid-col-1">

								<?php while ( $loop->have_posts() ) : $loop->the_post(); ?>

								<?php
									// Skip if not a post
									if( get_post_type() != 'post' ) {
										continue;
									}
								?>

									<?php
										// Assign default variable values used within loop
										$show = false;

										// Skip if current post is not in matching category
										$category = wp_get_post_terms(get_the_id(), 'category');

										foreach( $category as $categoryPost ) {

											// Get category term ID
											$term_id = (int) (isset($categoryPost->term_id) ? $categoryPost->term_id : null);

											// Exit loop on first match
											if( $term_id == $categoryId ) {
												$show = true;
												break;
											}
										}

										// Skip if current post shouldn't be shown
										if( empty( $show ) ) {
											continue;
										}
									?>

									<div class="blog-grid-item element<?php // thinkup_input_stylelayout(); ?>">

									<article id="post-<?php the_ID(); ?>" <?php post_class('blog-article'); ?>>

										<header class="entry-header<?php // thinkup_input_stylelayout_class1(); ?>">
											<?php thinkup_input_blogimage(); ?>
										</header>

										<div class="entry-content<?php // thinkup_input_stylelayout_class2(); ?>">
											<?php thinkup_input_blogmeta(); ?>
											<?php thinkup_input_blogtitle(); ?>
											<?php thinkup_input_blogtext(21); ?>
											<?php // thinkup_input_readmore(); ?>
										</div>

									<div class="clearboth"></div>
									</article><!-- #post-<?php get_the_ID(); ?> -->

									</div>

								<?php endwhile; ?>

							</div>

						</div>

					</div>

				</section><div class="clearboth"></div>

				<?php thinkup_input_pagination( $loop->max_num_pages ); ?>

			<?php else: ?>

				<?php get_template_part( 'no-results', 'archive' ); ?>

			<?php endif; wp_reset_postdata(); ?>

<?php get_footer() ?>