<section class="container page-section page-section2 themes-free-section themes-free-section2">
	<div class="container-core">

	<?php
	// Set arguments to get WooCommerce products
	$args = array(
		'post_type'   => 'free',
		'numberposts' => 100
	);

	// Get WooCommerce products (as array)
	$products = (array) get_posts($args);
	?>

	<div class="block-products block-style2 block-grid grid-col-1 grid-row-gap-50">

		<?php
			// Loop through each product and output
			foreach($products as $product ):

			// Convert product object to array
			$product = (array) $product;

			// Extract product info
			$product_id             = $product['ID'];
			$product_post_title     = $product['post_title'];
			$product_post_excerpt   = $product['post_excerpt'];

			// Get Pro theme product ID
			$product_id_pro = get_post_meta($product_id, 'theme_pro_id', true);

			// Get product thumbnail
			$product_url   = get_post_permalink( $product_id );
			$product_image = get_the_post_thumbnail_url( $product_id );

			// Get theme base name
			$product_theme_slug_base = get_post_meta($product_id_pro, 'theme_slug_base', true);
//			$product_theme_slug_base = 'consulting'; // TODO - Remove

			// Get product custom field values
			$product_theme_demo     = get_post_meta( $product_id, 'theme_demo', true);
			$product_theme_download = get_post_meta( $product_id, 'theme_download', true);
		?>

			<div class="block-product block-flex block-flex-start flex-column-gap-20 w800-block-flex-column">

				<div class="container-col block-product-col1 themes-free-section2-col1 flex-col-3">

					<div class="block-header">

						<div class="block-media">
							<a href="<?php echo $product_url; ?>"><img src="<?php echo untrailingslashit( get_site_url() ) . '/wp-content/themes/tut/images/themes/free/desktop/' . $product_theme_slug_base; ?>-desktop.jpg" /></a>
						</div>

					</div>
					<!-- .block-header -->

				</div>
				<!-- .themes-free-section2-col1 -->

				<div class="container-col block-product-col2 themes-free-section2-col2 flex-col-5">

					<div class="block-body">

						<h3 class="block-title"><?php echo $product_post_title; ?></h3>

						<div class="block-text">
							<?php echo $product_post_excerpt; ?>
						</div>

					</div>
					<!-- .block-body -->

					<div class="block-footer">

						<div class="block-buttons">

							<button class="button button-link button-s button-v1 button-cart border-radius-5" data-upify-event="button-cta-trial">
								<a href="<?php echo $product_url; ?>">Theme Features</a>
							</button>

							<button class="button button-link button-s button-v2 button-cart border-radius-5 margin-right-0" data-upify-event="button-cta-trial">
								<a href="<?php echo $product_theme_download; ?>" target="_blank">Download at WordPress.org</a>
							</button>

						</div>
						<!-- .block-buttons -->

					</div>
					<!-- .block-footer -->

				</div>
				<!-- .themes-free-section2-col2 -->

			</div>
			<!-- .block-product -->

		<?php endforeach ?>

	</div>
	<!-- .block-products -->

	</div>
</section>