<?php $products = wp_parse_args($args); // Re-assign args to products variable (to ensure naming consistency) ?>

<section class="container page-section page-section1 theme-section theme-section1">
	<div class="container-core block-flex flex-column-gap-60 flex-row-gap-70 w800-block-flex-column">

		<div class="container-col theme-section1-col1 flex-col-5 w800-center-all">

			<div class="block-header">
				<h3 class="block-title"><?php echo $products['parent']['title']; ?></h3>
			</div>

			<div class="block-body">

				<div class="block-media image-desktop">
					<img src="<?php echo untrailingslashit( get_site_url() ) . '/wp-content/themes/tut/images/themes/pro/desktop/' . $products['parent']['theme_slug_base']; ?>-desktop.jpg">
				</div>

				<div class="block-media image-mobile w800-hide">
					<img src="<?php echo untrailingslashit( get_site_url() ) . '/wp-content/themes/tut/images/themes/pro/mobile/' . $products['parent']['theme_slug_base']; ?>-mobile.jpg">
				</div>

			</div>

		</div>
		<!-- .theme-section1-col1 -->

		<div class="container-col theme-section1-col2 flex-col-3">

			<div class="block-pricing block-style2 data-container">

				<div class="block-header">

					<h4 class="block-title">Pricing Options</h4>

					<div class="block-text">
						<p>All of our themes come with free annual expert support and updates for all active sites.</p>
<?php /*						<p>All of our themes come with 1 year free expert support and updates for all active sites.</p> */ ?>
					</div>

				</div>
				<!-- .block-header -->

				<div class="block-body">

					<div class="block-prices">

						<?php foreach( $products['child'] as $key => $value ): ?>

							<?php

								// Reset variable values used within loop
								$attr_data = (string) null;

								// Assign default option
								if( $products['default']['id'] == $value['id'] ) {
									$attr_data = ' data-value="1"';
								}
							?>

							<div class="block-price item-select block-flex data-option-pricing"<?php echo $attr_data; ?> data-option="<?php echo $key; ?>">
								<div class="item-info">
									<span class="item-icon"><i class="fal fa-check"></i></span>
									<span class="item-name"><?php echo $value['desc']; ?></span>
								</div>
								<div class="item-price">$<?php echo $value['price']; ?></div>
							</div>

						<?php endforeach; ?>

					</div>

				</div>
				<!-- .block-body -->

				<div class="block-footer">

					<div class="block-buttons block-flex block-flex-start flex-column-gap-20 w480-block-flex-column">

						<button class="button button-link button-m button-v1 button-cart border-radius-5 margin-right-0 flex-col-2">
							<a class="padding-0 button-cart-link" href="<?php echo $products['default']['url_cart']; ?>">Buy Now</a>
						</button>

						<button class="button button-link button-m button-v1 button-demo border-radius-5 margin-right-0 flex-col-2">
							<a class="padding-0" href="<?php echo $products['parent']['url_demo']; ?>" target="_blank">View Demo</a>
						</button>

					</div>

				</div>
				<!-- .block-footer -->

				<div class="data-content">
					<?php foreach( $products['child'] as $key => $value ): ?>
						<div class="option-data" data-option="<?php echo $key; ?>" data-value="<?php echo esc_url( $value['url_cart'] ); ?>"></div>
					<?php endforeach; ?>
				</div>
				<!-- .data-content -->

			</div>

		</div>
		<!-- .theme-section1-col2 -->

	</div>
</section>