<?php $products = wp_parse_args($args); // Re-assign args to products variable (to ensure naming consistency)

// Setup content array
$items = array(
	array( 'title' => 'Mobile Friendly',           'free' => 'yes',   'pro' => 'yes'       ),
	array( 'title' => 'Background Image',          'free' => 'yes',   'pro' => 'yes'       ),
	array( 'title' => 'Fontpage Sections',         'free' => '3',     'pro' => 'Unlimited' ),
	array( 'title' => 'Fontpage Slides',           'free' => '3',     'pro' => 'Unlimited' ),
	array( 'title' => 'Built-In Social Buttons',   'free' => '7',     'pro' => 'Unlimited' ),
	array( 'title' => 'Advanced Theme Options',    'free' => 'Basic', 'pro' => 'yes'       ),
	array( 'title' => 'Page Builder',              'free' => 'no',    'pro' => 'yes'       ),
	array( 'title' => 'Theme Options Panel',       'free' => 'no',    'pro' => 'yes'       ),
	array( 'title' => 'Unlimited Color Options',   'free' => 'no',    'pro' => 'yes'       ),
	array( 'title' => '600+ Google Fonts',         'free' => 'no',    'pro' => 'yes'       ),
	array( 'title' => '150+ Shortcodes',           'free' => 'no',    'pro' => 'yes'       ),
	array( 'title' => 'ThinkUpSlider',             'free' => 'no',    'pro' => 'yes'       ),
	array( 'title' => 'Unlimited Sliders',         'free' => 'no',    'pro' => 'yes'       ),
	array( 'title' => 'Video Sliders',             'free' => 'no',    'pro' => 'yes'       ),
	array( 'title' => 'Portfolio',                 'free' => 'no',    'pro' => 'yes'       ),
	array( 'title' => 'Google Map Section',        'free' => 'no',    'pro' => 'yes'       ),
	array( 'title' => 'Custom Widgets',            'free' => 'no',    'pro' => 'yes'       ),
	array( 'title' => 'Parallax Effects',          'free' => 'no',    'pro' => 'yes'       ),
	array( 'title' => 'Animation Effects',         'free' => 'no',    'pro' => 'yes'       ),
	array( 'title' => 'Extended Layout Options',   'free' => 'no',    'pro' => 'yes'       ),
	array( 'title' => 'Premium Support',           'free' => 'no',    'pro' => 'yes'       ),
	array( 'title' => 'Custom footer credit link', 'free' => 'no',    'pro' => 'yes'       ),
);

?>

<section class="container page-section page-section5 theme-section theme-section5">
	<div class="container-core">

		<div class="container-row theme-section5-row1">

			<h3 class="block-title"><?php echo $products['free']['title']; ?> vs Pro?</h3>

		</div>

		<div class="container-row theme-section5-row2">

			<div class="block-table block-style1">

			<div class="block-table-row block-table-header block-flex">
				<div class="block-table-col item-name">
					<span>Feature</span>
				</div>
				<div class="block-table-col item-free">
					<span>Free</span>
				</div>
				<div class="block-table-col item-pro">
					<span>Pro</span>
				</div>
			</div>

			<?php foreach( $items as $item ): ?>

				<?php
					// Extract values from item
					$item_title = (string) (isset($item['title']) ? $item['title'] : null);
					$item_free  = (string) (isset($item['free'])  ? $item['free']  : null);
					$item_pro   = (string) (isset($item['pro'])   ? $item['pro']   : null);

					// Replace free item with icon if needed
					if( $item_free == 'yes' ) {
						$item_free = '<i class="far fa-check"></i>';
					} elseif( $item_free == 'no' ) {
						$item_free = '<i class="far fa-times"></i>';
					}

					// Replace free item with icon if needed
					if( $item_pro == 'yes' ) {
						$item_pro = '<i class="far fa-check"></i>';
					} elseif( $item_pro == 'no' ) {
						$item_pro = '<i class="far fa-times"></i>';
					}
				?>

				<div class="block-table-row block-flex">
					<div class="block-table-col item-name">
						<span><?php echo $item_title; ?></span>
					</div>
					<div class="block-table-col item-free">
						<span><?php echo $item_free; ?></span>
					</div>
					<div class="block-table-col item-pro">
						<span><?php echo $item_pro; ?></span>
					</div>
				</div>

			<?php endforeach; ?>

			</div>

		</div>

	</div>
</section>