<?php
/**
 * The Header for our theme.
 *
 * Displays all of the <head> section and everything up until id="main-core".
 *
 * @package ThinkUpThemes
 */
?><!DOCTYPE html>

<html <?php language_attributes(); ?>>
<head>
<?php // thinkup_hook_header(); ?>
<meta charset="<?php bloginfo( 'charset' ); ?>" />
<meta name="viewport" content="width=device-width" />
<link rel="profile" href="//gmpg.org/xfn/11" />
<link rel="pingback" href="<?php esc_url( bloginfo( 'pingback_url' ) ); ?>" />

<link rel="icon" href="<?php echo get_template_directory_uri(); ?>/images/misc/favicon.png" type="image/png" />

<link rel="preconnect" href="https://fonts.googleapis.com">
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>

<link href="https://fonts.googleapis.com/css2?family=Inter:wght@100;200;300;400;500;600;700;800;900&display=swap" rel="stylesheet">
<link href="https://fonts.googleapis.com/css2?family=Nunito:wght@200;300;400;500;600;700;800;900;1000&display=swap" rel="stylesheet">
<link href="https://fonts.googleapis.com/css2?family=DM+Sans:wght@100;200;300;400;500;600;700;800;900&display=swap" rel="stylesheet">


<!-- Formilla -->
<!--
<script type="text/javascript">
    (function () {
        var head = document.getElementsByTagName("head").item(0);
        var script = document.createElement("script");

        var src = (document.location.protocol == 'https:'
            ? 'https://www.formilla.com/scripts/feedback.js'
            : 'http://www.formilla.com/scripts/feedback.js');

        script.setAttribute("type", "text/javascript");
        script.setAttribute("src", src); script.setAttribute("async", true);

        var complete = false;

        script.onload = script.onreadystatechange = function () {
            if (!complete && (!this.readyState
                    || this.readyState == 'loaded'
                    || this.readyState == 'complete')) {
                complete = true;
                Formilla.guid = 'cs1cd664-011a-4c89-8727-8b4cffcb0311';
                Formilla.loadWidgets();
            }
        };

        head.appendChild(script);
    })();
</script>
 -->

<?php
if( ! is_archive() && ! empty( get_post_meta( get_the_ID(), 'thinkup_wp_head', true ) ) ) {
	echo get_post_meta( get_the_ID(), 'thinkup_wp_head', true );
}
?>

<!--
<link rel="preload" as="font" href="<?php echo untrailingslashit( get_template_directory_uri() ) ?>/lib/extentions/fontawesome-pro/webfonts/fa-light-300.woff2" crossorigin>
<link rel="preload" as="font" href="<?php echo untrailingslashit( get_template_directory_uri() ) ?>/lib/extentions/fontawesome-pro/webfonts/fa-regular-400.woff2" crossorigin>
<link rel="preload" as="font" href="<?php echo untrailingslashit( get_template_directory_uri() ) ?>/lib/extentions/fontawesome-pro/webfonts/fa-solid-900.woff2" crossorigin>
<link rel="preload" as="font" href="<?php echo untrailingslashit( get_template_directory_uri() ) ?>/lib/extentions/fontawesome-pro/webfonts/fa-duotone-900.woff2" crossorigin>
-->

<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
<div id="body-core" class="hfeed site">

	<?php // get_template_part('templates/global/header-notice/_header-notice-v1'); ?>

	<header id="site-header">

		<?php if ( get_header_image() ) : ?>
			<div class="custom-header"><img src="<?php header_image(); ?>" width="<?php echo esc_attr( get_custom_header()->width ); ?>" height="<?php echo esc_attr( get_custom_header()->height ); ?>" alt=""></div>
		<?php endif; // End header image check. ?>

		<div class="block-scroll-read">
			<div class="block-scroll-read-core">
			</div>
		</div>
		<!-- #block-scroll-read -->

		<div id="pre-header">
		<div class="wrap-safari">
		<div id="pre-header-core" class="main-navigation">

			<?php if ( has_nav_menu( 'pre_header_menu' ) ) : ?>
			<?php wp_nav_menu( array( 'container_class' => 'header-links', 'container_id' => 'pre-header-links-inner', 'theme_location' => 'pre_header_menu' ) ); ?>
			<?php endif; ?>

		</div>
		</div>
		</div>
		<!-- #pre-header -->

		<div id="header" class="w800-hide uk-sticky uk-sticky-fixed" uk-sticky>
		<div id="header-core">

			<div id="logo" class="menu-logo">
				<a href="https://weselltalent.com">
<?php /*				<a href="<?php echo untrailingslashit( get_home_url() ) ?>"> */ ?>
<?php /*				<a href="<?php echo trailingslashit( get_home_url() ) ?>"> */ ?>
					<img src="<?php echo untrailingslashit( get_template_directory_uri() ) ?>/images/misc/logo.png" srcset="<?php echo untrailingslashit( get_template_directory_uri() ) ?>/images/misc/logo-2x.png" alt="Logo" width="120" height="19">
					<span class="logo-info">Blog</span>
				</a>
			</div>

			<div id="header-links" class="main-navigation">
			<div id="header-links-inner" class="header-links">
				<?php wp_nav_menu(array('container' => false, 'theme_location'  => 'header_menu')); ?>
			</div>
			</div>
			<!-- #header-links .main-navigation -->

		</div>
		</div>
		<!-- #header -->

		<?php get_template_part('templates/global/header/_header-mobile'); ?>

	</header>
	<!-- header -->

	<main id="main" role="main">