<?php

/**
 * Add Yoast SEO sitemap option to WP Rocket default options
 *
 * @since 2.8
 * @since 3.11.1 deprecated
 *
 * @author Remy Perona
 *
 * @param array $options WP Rocket options array.
 * @return array Updated WP Rocket options array
 */
function rocket_add_yoast_seo_sitemap_option( $options ) {
	_deprecated_function( __FUNCTION__ . '()', '3.11.1' );

	$options['yoast_xml_sitemap'] = 0;

	return $options;
}

/**
 * Sanitize Yoast SEO sitemap option value
 *
 * @since 2.8
 * @since 3.11.1 deprecated
 *
 * @author Remy Perona
 *
 * @param array $inputs WP Rocket inputs array.
 * @return array Sanitized WP Rocket inputs array
 */
function rocket_yoast_seo_sitemap_option_sanitize( $inputs ) {
	_deprecated_function( __FUNCTION__ . '()', '3.11.1' );

	$inputs['yoast_xml_sitemap'] = ! empty( $inputs['yoast_xml_sitemap'] ) ? 1 : 0;

	return $inputs;
}

/**
 * Add Yoast SEO sitemap URL to the sitemaps to preload
 *
 * @since 2.8
 * @since 3.11.1 deprecated
 *
 * @author Remy Perona
 *
 * @param array $sitemaps Sitemaps to preload.
 * @return array Updated Sitemaps to preload
 */
function rocket_add_yoast_seo_sitemap( $sitemaps ) {
	_deprecated_function( __FUNCTION__ . '()', '3.11.1' );

	if ( get_rocket_option( 'yoast_xml_sitemap', false ) ) {
		$sitemaps[] = WPSEO_Sitemaps_Router::get_base_url( 'sitemap_index.xml' );
	}

	return $sitemaps;
}

/**
 * Add Yoast SEO option to WP Rocket settings
 *
 * @since 2.8
 * @since 3.11.1 deprecated
 *
 * @author Remy Perona
 *
 * @param array $options WP Rocket settings array.
 * @return array Updated WP Rocket settings array
 */
function rocket_sitemap_preload_yoast_seo_option( $options ) {
	_deprecated_function( __FUNCTION__ . '()', '3.11.1' );

	$options['yoast_xml_sitemap'] = [
		'type'              => 'checkbox',
		'container_class'   => [
			'wpr-field--children',
		],
		'label'             => __( 'Yoast SEO XML sitemap', 'rocket' ),
		// translators: %s = Name of the plugin.
		'description'       => sprintf( __( 'We automatically detected the sitemap generated by the %s plugin. You can check the option to preload it.', 'rocket' ), 'Yoast SEO' ),
		'parent'            => 'sitemap_preload',
		'section'           => 'preload_section',
		'page'              => 'preload',
		'default'           => 0,
		'sanitize_callback' => 'sanitize_checkbox',
	];

	return $options;
}
