<?php
/**
* Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
* 
* MiracastChannel File
* PHP version 7
*
* @category  Library
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
namespace Microsoft\Graph\Model;

use Microsoft\Graph\Core\Enum;

/**
* MiracastChannel class
*
* @category  Model
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
class MiracastChannel extends Enum
{
    /**
    * The Enum MiracastChannel
    */
    const USER_DEFINED = "userDefined";
    const ONE = "one";
    const TWO = "two";
    const THREE = "three";
    const FOUR = "four";
    const FIVE = "five";
    const SIX = "six";
    const SEVEN = "seven";
    const EIGHT = "eight";
    const NINE = "nine";
    const TEN = "ten";
    const ELEVEN = "eleven";
    const THIRTY_SIX = "thirtySix";
    const FORTY = "forty";
    const FORTY_FOUR = "fortyFour";
    const FORTY_EIGHT = "fortyEight";
    const ONE_HUNDRED_FORTY_NINE = "oneHundredFortyNine";
    const ONE_HUNDRED_FIFTY_THREE = "oneHundredFiftyThree";
    const ONE_HUNDRED_FIFTY_SEVEN = "oneHundredFiftySeven";
    const ONE_HUNDRED_SIXTY_ONE = "oneHundredSixtyOne";
    const ONE_HUNDRED_SIXTY_FIVE = "oneHundredSixtyFive";
}